<?php 

class Pos extends MY_Controller
{
    public $module_name;
	function __construct()
    {
        parent::__construct();

        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Extra_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Charge_type_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Booking_model');
        $this->load->helper('timezone');
        $this->load->helper('date_format_helper');
        
        $this->load->library('PaymentGateway');
        $this->load->library('Forecast_charges');
        $this->load->library('Tokenex');
       
        $view_data['menu_on']          = true;
        $this->load->vars($view_data);
        
    }


    function open_pos_modal(){
        $booking_id=$this->input->post('booking_id');
        $data['charge_types']  = $this->Charge_type_model->get_charge_types($this->company_id);
        $data['pos_extras'] = $this->Extra_model->get_extras($this->company_id, true);
        $data['booking_detail'] = $this->Booking_model->get_booking_detail($booking_id);

        $this->load->view('../extensions/'.$this->module_name.'/views/pos',$data);
    }

    function search_pos_items() {
        $item_name = $this->input->post('item');
        $result = $this->Extra_model->get_pos_extra_items($this->company_id, $item_name);
        echo json_encode($result);
    }
}